/*
 * Copyright (c) 2019 Nuclei Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __${csp?upper_case}_VERSION_H
#define __${csp?upper_case}_VERSION_H

/**
 * \defgroup ${csp?upper_case}_Core_VersionControl    Version Control
 * \ingroup  ${csp?upper_case}_Core
 * \brief    Version \#define symbols for ${csp?upper_case} release specific C/C++ source code
 * \details
 *
 * We followed the [semantic versioning 2.0.0](https://semver.org/) to control ${csp?upper_case} version.
 * The version format is **MAJOR.MINOR.PATCH**, increment the:
 * 1. MAJOR version when you make incompatible API changes,
 * 2. MINOR version when you add functionality in a backwards compatible manner, and
 * 3. PATCH version when you make backwards compatible bug fixes.
 *
 * The header file `${csp}_version.h` is included by each core header so that these definitions are available.
 *
 * **Example Usage for ${csp?upper_case} Version Check**:
 * \code
 *   #if defined(__${csp?upper_case}_VERSION) && (__${csp?upper_case}_VERSION >= 0x00010105)
 *      #warning "Yes, we have ${csp?upper_case} 1.1.5 or later"
 *   #else
 *      #error "We need ${csp?upper_case} 1.1.5 or later!"
 *   #endif
 * \endcode
 *
 * @{
 */

/*!
 * \file     ${csp}_version.h
 * \brief    ${csp?upper_case} Version definitions
 **/

/**
 * \brief   Represent the ${csp?upper_case} major version
 * \details
 * The ${csp?upper_case} major version can be used to
 * differentiate between ${csp?upper_case} major releases.
 * */
#define __${csp?upper_case}_VERSION_MAJOR            (1U)

/**
 * \brief   Represent the ${csp?upper_case} minor version
 * \details
 * The ${csp?upper_case} minor version can be used to
 * query a ${csp?upper_case} release update including new features.
 *
 **/
#define __${csp?upper_case}_VERSION_MINOR            (2U)

/**
 * \brief   Represent the ${csp?upper_case} patch version
 * \details
 * The ${csp?upper_case} patch version can be used to
 * show bug fixes in this package.
 **/
#define __${csp?upper_case}_VERSION_PATCH            (0U)
/**
 * \brief   Represent the ${csp?upper_case} Version
 * \details
 * ${csp?upper_case} Version format: **MAJOR.MINOR.PATCH**
 * * MAJOR: \ref __${csp?upper_case}_VERSION_MAJOR, stored in `bits [31:16]` of \ref __${csp?upper_case}_VERSION
 * * MINOR: \ref __${csp?upper_case}_VERSION_MINOR, stored in `bits [15:8]` of \ref __${csp?upper_case}_VERSION
 * * PATCH: \ref __${csp?upper_case}_VERSION_PATCH, stored in `bits [7:0]` of \ref __${csp?upper_case}_VERSION
 **/
#define __${csp?upper_case}_VERSION                  ((__${csp?upper_case}_VERSION_MAJOR << 16U) | (__${csp?upper_case}_VERSION_MINOR << 8) | __${csp?upper_case}_VERSION_PATCH)

/** @} */ /* End of Doxygen Group ${csp?upper_case}_Core_VersionControl */
#endif
