## Package Base Information
name: csp-nsdk_${csp}
owner: ${owner!"nuclei"}
version: ${version!""}
description: ${vendor!"Nuclei"} ${csp} Core Support Package
type: csp
keywords:
  - ${csp}
  - risc-v
  - ${vendor!"nuclei"}
license: ${license!""}
homepage: ${homepage!""}
contributors:
<#list contributors as con>
  - ${con}
</#list>

## Package Configurations
configuration:
  nmsislibarch:
    value: "rv32imac"
    type: text
    global: false
    description: RISC-V ARCH for ${csp?upper_case} library
  nmsislibsel:
    default_value: none
    type: choice
    global: true
    description: Select ${csp?upper_case} Library
    choices:
      - name: none
        description: No ${csp?upper_case} Library used
      - name: nmsis_dsp
        description: ${csp?upper_case} DSP Library
      - name: nmsis_nn
        description: ${csp?upper_case} NN Library
      - name: nmsis_dsp_nn
        description: ${csp?upper_case} DSP and NN Library

## Source Code Management
codemanage:
  installdir: ${csp?upper_case}
  copyfiles:
    - path: ["Core"]
    - path: ["DSP", "Library/DSP"]
      condition: <#noparse>$( contains(${nmsislibsel}, "nmsis_dsp") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
    - path: ["NN", "Library/NN"]
      condition: $( contains(${nmsislibsel}, "nmsis_nn") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
  incdirs:
    - path: ["Core/Include"]
    - path: ["DSP/Include", "DSP/PrivateInclude"]
      condition: $( contains(${nmsislibsel}, "nmsis_dsp") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
    - path: ["NN/Include"]
      condition: $( contains(${nmsislibsel}, "nmsis_nn") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
  libdirs:
    - path: ["Library/DSP/GCC"]
      condition: $( contains(${nmsislibsel}, "nmsis_dsp") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
    - path: ["Library/NN/GCC"]
      condition: $( contains(${nmsislibsel}, "nmsis_nn") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
  ldlibs:
    - libs: ["nmsis_nn_${nmsislibarch}"]
      condition: $( contains(${nmsislibsel}, "nmsis_nn") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
    - libs: ["nmsis_dsp_${nmsislibarch}"]
      condition: $( contains(${nmsislibsel}, "nmsis_dsp") || contains(${nmsislibsel}, "nmsis_dsp_nn") )
</#noparse>