## Package Base Information
name: osp-${sdk}_rtthread
version: 3.1.3
owner: ${owner!"nuclei"}
description: RT-Thread Nano
type: osp
keywords:
  - rtos
  - risc-v
license: Apache-2.0
homepage: https://github.com/RT-Thread/rtthread-nano

## Package Dependency
dependencies:
  - name: sdk-${sdk}_sdk
    version:

## Package Configurations
configuration:
  rtthread_msh:
    default_value: 0
    type: checkbox
    global: false
    description: Select RT-Thread MSH Component

## Source Code Management
codemanage:
  installdir: RTThread
  copyfiles:
    - path: ["src", "include"]
    - path: ["libcpu/risc-v/${vendor!"nuclei"}/gcc", "libcpu/risc-v/${vendor!"nuclei"}/cpuport.c", "libcpu/risc-v/${vendor!"nuclei"}/cpuport.h"]
    - path: ["components/finsh"]<#noparse>
      condition: $( ${rtthread_msh} == 1 )
  incdirs:
    - path: ["include"]
    - path: ["components/finsh"]
      condition: $( ${rtthread_msh} == 1 )</#noparse>
  libdirs:
  ldlibs:

## Build Configuration
buildconfig:
  - type: common
    common_defines:
      - defines: RTOS_RTTHREAD
