## Package Base Information
name: app-${sdk}_coremark
owner: ${owner!"nuclei"}
version:
description: Coremark Benchmark
type: app
keywords:
  - baremetal
  - benchmark
category: baremetal application
license: Apache-2.0
homepage: https://www.eembc.org/coremark/

## Package Dependency
dependencies:
  - name: sdk-${sdk}_sdk
    version:

## Package Configurations
configuration:
  cpu_series:
    default_value: 300
    type: choice
    description: Select Benchmark Options
    choices:
      - name: 200
        description: Options for Nuclei 200 Series
      - name: 300
        description: Options for Nuclei 300 Series
      - name: 600
        description: Options for Nuclei 600 Series
      - name: 900
        description: Options for Nuclei 900 Series

## Set Configuration for other packages
setconfig:
  - config: stdclib
    value: newlib_small

## Source Code Management
codemanage:
  copyfiles:
    - path: ["*.c", "*.h"]
  incdirs:
    - path: ["./"]
  libdirs:
  ldlibs:
<#noparse>
## Build Configuration
buildconfig:
  - type: common
    cdefines:
      - defines: FLAGS_STR=\""See compiler options passed in IDE"\"
      - defines: ITERATIONS=800
      - defines: PERFORMANCE_RUN=1
  - type: gcc
    common_flags: # flags need to be combined together across all packages
      - flags: >-
              -Ofast -fno-code-hoisting -fno-tree-vectorize -fno-common -finline-functions -falign-functions=4
              -falign-jumps=4 -falign-loops=4 -finline-limit=200 -fno-if-conversion -fno-if-conversion2 -fipa-pta
              -fselective-scheduling -fno-tree-loop-distribute-patterns -funroll-loops -funroll-all-loops
              -fno-delete-null-pointer-checks -fno-rename-registers -mbranch-cost=1 --param fsm-scale-path-stmts=3
              --param max-average-unrolled-insns=200 --param max-grow-copy-bb-insns=20 --param max-jump-thread-duplication-stmts=25
              --param hot-bb-frequency-fraction=4 --param unroll-jam-min-percent=0

        condition: $( ${cpu_series} == 200 )
      - flags: >-
              -Ofast -fno-code-hoisting -fno-tree-vectorize -fno-common -finline-functions -falign-functions=4
              -falign-jumps=4 -falign-loops=4 -finline-limit=200 -fno-if-conversion -fno-if-conversion2 -fipa-pta
              -fselective-scheduling -fno-tree-loop-distribute-patterns -funroll-loops -funroll-all-loops
              -fno-delete-null-pointer-checks -fno-rename-registers -mbranch-cost=1 --param fsm-scale-path-stmts=5
              --param max-average-unrolled-insns=200 --param max-grow-copy-bb-insns=20 --param max-jump-thread-duplication-stmts=25
              --param hot-bb-frequency-fraction=4 --param unroll-jam-min-percent=0

        condition: $( ${cpu_series} == 300 )
      - flags: >-
              -Ofast -fno-code-hoisting -fno-tree-vectorize -fno-common -finline-functions
              -falign-functions=4 -falign-jumps=4 -falign-loops=4 -finline-limit=200  -fno-if-conversion
              -fno-if-conversion2 -fipa-pta -fselective-scheduling -fno-tree-loop-distribute-patterns
              -funroll-loops -funroll-all-loops -fno-delete-null-pointer-checks -fno-rename-registers
              -mbranch-cost=1 --param fsm-scale-path-stmts=5 --param max-average-unrolled-insns=200
              --param max-grow-copy-bb-insns=16 --param max-jump-thread-duplication-stmts=14
              --param hot-bb-frequency-fraction=4 --param unroll-jam-min-percent=0

        condition: $( ${cpu_series} == 600 )
      - flags: >-
              -Ofast -mbranch-cost=1 -mstrict-align -funroll-all-loops -finline-limit=500
              -ftree-dominator-opts -fselective-scheduling -funroll-loops -finline-functions -falign-functions=4
              -falign-jumps=4 -falign-loops=4 -fipa-pta -fno-code-hoisting -fno-common -fno-if-conversion
              -fno-if-conversion2 -fno-tree-loop-distribute-patterns -fno-tree-vectorize -fno-tree-loop-ivcanon
              -ftree-vrp -fgcse-las --param=max-loop-header-insns=4 --param loop-max-datarefs-for-datadeps=0
              --param=unroll-jam-min-percent=0 --param=max-goto-duplication-insns=0
              --param max-jump-thread-duplication-stmts=19 --param fsm-scale-path-stmts=3 --param max-grow-copy-bb-insns=12

        condition: $( ${cpu_series} == 900 )
  - type: clang
    common_flags: # flags need to be combined together across all packages
      - flags: -O3 -flto
</#noparse>