## Package Base Information
name: app-${sdk}_dhrystone
owner: ${owner!"nuclei"}
version:
description: Dhrystone Benchmark
type: app
keywords:
  - baremetal
  - benchmark
category: baremetal application
license:
homepage:

## Package Dependency
dependencies:
  - name: sdk-${sdk}_sdk
    version:

## Package Configurations
configuration:
  dhry_mode:
    default_value: ground
    type: choice
    description: Dhrystone Options
    choices:
      - name: ground
        description: Ground Rules
      - name: inline
        description: Inline
      - name: best
        description: Best Effort

## Set Configuration for other packages
setconfig:
  - config: stdclib
    value: newlib_small

## Source Code Management
codemanage:
  copyfiles:
    - path: ["*.c", "*.h", "*.S"]
  incdirs:
    - path: ["./"]
  libdirs:
  ldlibs:
<#noparse>
## Build Configuration
buildconfig:
  - type: gcc
    common_flags: # flags need to be combined together across all packages
      - flags: >-
              -O3 -flto -fno-inline -funroll-loops -Wno-implicit -mexplicit-relocs
              -fno-builtin-printf -fno-common -falign-functions=4 -falign-jumps=4 -falign-loops=4

        condition: $( ${dhry_mode} == 'ground' )
      - flags: >-
              -O3 -flto -finline -funroll-loops -Wno-implicit -mexplicit-relocs -fno-builtin-printf
              -fno-common -falign-functions=4 -falign-jumps=4 -falign-loops=4 -finline-functions

        condition: $( ${dhry_mode} == 'inline' )
      - flags: >-
              -Ofast -flto -fwhole-program -finline -funroll-loops -Wno-implicit -mexplicit-relocs
              -fno-builtin-printf -fno-common -falign-functions=4 -falign-jumps=4 -falign-loops=4
              -finline-functions

        condition: $( ${dhry_mode} == 'best' )
  - type: clang
    common_flags: # flags need to be combined together across all packages
      - flags: >-
              -Ofast -flto -fno-inline -funroll-loops -Wno-implicit -fno-builtin-printf -falign-functions=4 -falign-loops=4

        condition: $( ${dhry_mode} == 'ground' )
      - flags: >-
              -Ofast -flto -finline -funroll-loops -Wno-implicit -fno-builtin-printf -falign-functions=4 -falign-loops=4 -finline-functions

        condition: $( ${dhry_mode} == 'inline' )
      - flags: >-
              -O3 -flto -finline -funroll-loops -Wno-implicit -fno-builtin-printf -falign-functions=4 -falign-loops=4 -finline-functions

        condition: $( ${dhry_mode} == 'best' )
</#noparse>