## Package Base Information
name: app-${sdk}_whetstone
owner: ${owner!"nuclei"}
version:
description: Whetstone Benchmark
type: app
keywords:
  - baremetal
  - benchmark
category: baremetal application
license:
homepage:

## Package Dependency
dependencies:
  - name: sdk-${sdk}_sdk
    version:

## Package Configurations
configuration:

## Set Configuration for other packages
setconfig:
  - config: stdclib
    value: newlib_small

## Source Code Management
codemanage:
  copyfiles:
    - path: ["*.c", "*.h"]
  incdirs:
    - path: ["./"]
  libdirs:
  ldlibs:
    # only link with math library when using newlib library
    # no need for libncrt library
    - libs: ["m"]
      condition: <#noparse>$( startswith(${stdclib}, "newlib") )</#noparse>

## Build Configuration
buildconfig:
  - type: gcc
    common_flags: # flags need to be combined together across all packages
      - flags: -O3 -funroll-loops -fsingle-precision-constant
  - type: clang
    common_flags: # flags need to be combined together across all packages
      - flags: -O3 -funroll-loops -flto
