## Package Base Information
name: app-${sdk}_demo_dsp
owner: ${owner!"nuclei"}
version:
description: ${vendor!"Nuclei"} NMSIS DSP Library Demo
type: app
keywords:
  - baremetal
  - riscv dsp
category: baremetal application
license:
homepage:

## Package Dependency
dependencies:
  - name: sdk-${sdk}_sdk
    version:

## Package Configurations
configuration:
  app_commonflags:
    value:
    type: text
    description: Application Compile Flags

## Set Configuration for other packages
setconfig:
  - config: nmsislibsel
    value: nmsis_dsp
  - config: stdclib
    value: newlib_small

## Source Code Management
codemanage:
  copyfiles:
    - path: ["*.c", "*.h"]
  incdirs:
    - path: ["./"]
  libdirs:
  ldlibs:
    # only link with math library when using newlib library
    # no need for libncrt library
    - libs: ["m"]
      condition: <#noparse>$( startswith(${stdclib}, "newlib") )

## Build Configuration
buildconfig:
  - type: common
    common_flags: # flags need to be combined together across all packages
      - flags: ${app_commonflags}</#noparse>
